﻿//If the SDK namespace object is not defined, create it.
if (typeof (MCS) == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;
MCS.cvt_MTSA_OnChange = {};

//Specialty
MCS.cvt_MTSA_OnChange.Specialty = function () {
    //See if any sub-types exist
    if (Xrm.Page.getAttribute("cvt_servicetype").getValue() != null) {
        calls = CrmRestKit.ByQuery("mcs_servicesubtype", ['mcs_name'], "cvt_relatedServiceTypeId/Id eq guid'" + Xrm.Page.getAttribute("cvt_servicetype").getValue()[0].id + "'", false);
        calls.fail(function (err) {
            Xrm.Page.getControl("cvt_servicesubtype").setVisible(false);
            Xrm.Page.getAttribute("cvt_servicesubtype").setValue(null);
        }).done(function (data) {
            if (data && data.d && data.d.results != null && data.d.results.length != 0) {
                Xrm.Page.getControl("cvt_servicesubtype").setVisible(true);
                Xrm.Page.getControl("cvt_servicesubtype").setFocus();
            }
            else
            {
                Xrm.Page.getControl("cvt_servicesubtype").setVisible(false);
                Xrm.Page.getAttribute("cvt_servicesubtype").setValue(null);
            }

            MCS.cvt_MTSA_OnLoad.SOS();
        });
    }
    else
    {
        Xrm.Page.getControl("cvt_servicesubtype").setVisible(false);
        Xrm.Page.getAttribute("cvt_servicesubtype").setValue(null);
    }
};

//Provider Site TCT Team
MCS.cvt_MTSA_OnChange.TCTTeam = function () {
    //See if any sub-types exist
    if (Xrm.Page.getAttribute("cvt_relatedsiteid").getValue() != null) {
        calls = CrmRestKit.ByQuery("Team", ['Name', 'TeamId'], "cvt_Type/Value eq 917290007 and cvt_TMPSite/Id eq (Guid'" + Xrm.Page.getAttribute("cvt_relatedsiteid").getValue()[0].id + "')", false);
        calls.fail(function (err) {
            //Fail
        }).done(function (data) {
            if (data && data.d && data.d.results != null && data.d.results.length != 0) {
                //Set the TCT Team
                var teamObj = new Array();
                teamObj[0] = new Object();
                teamObj[0].id = data.d.results[0].TeamId;
                teamObj[0].name = data.d.results[0].Name;
                teamObj[0].entityType = 'Team';

                Xrm.Page.getAttribute("cvt_providersitetctteam").setValue(teamObj)
            }
            else
                Xrm.Page.getAttribute("cvt_providersitetctteam").setValue(null);
        });
    }
    else
        Xrm.Page.getAttribute("cvt_providersitetctteam").setValue(null);
};
//Home/Mobile
MCS.cvt_MTSA_OnChange.Type = function () {
    var Type = (Xrm.Page.getAttribute("cvt_type").getValue()) ? Xrm.Page.getAttribute("cvt_type").getValue() : false;

    if (Type == false) { //Clinic Based
        if (Xrm.Page.ui.getFormType() == MCS.cvt_Common.FORM_TYPE_CREATE) {
            //Xrm.Page.getControl("cvt_capacity").setDisabled(false);
            Xrm.Page.getControl("cvt_availabletelehealthmodalities").setDisabled(false);
        }
    }
    else { //true //CVT to Home
        if (Xrm.Page.ui.getFormType() == MCS.cvt_Common.FORM_TYPE_CREATE) {
            Xrm.Page.getAttribute("cvt_availabletelehealthmodalities").setValue(917290000);
            Xrm.Page.getAttribute("cvt_availabletelehealthmodalities").setSubmitMode("always");
            Xrm.Page.getAttribute("cvt_availabletelehealthmodalities").fireOnChange(); //Make sure the form displays the correct fields
        }
        
        Xrm.Page.getControl("cvt_groupappointment").setVisible(true);
        Xrm.Page.getControl("cvt_groupappointment").setDisabled(false);
        Xrm.Page.getControl("cvt_availabletelehealthmodalities").setDisabled(true);
    }
};
//Store Forward
MCS.cvt_MTSA_OnChange.StoreForward = function () {
    //Check if this TSA is store forward
    var SFT = Xrm.Page.getAttribute("cvt_availabletelehealthmodalities").getValue() == 917290001;
    Xrm.Page.getControl("cvt_groupappointment").setVisible(!SFT);
    if (SFT) {
        if (Xrm.Page.getAttribute("cvt_servicelevels").getValue() == null)
            Xrm.Page.getAttribute("cvt_servicelevels").setValue(917290000);
    }
};